<?php

use App\Http\Controllers\BookController;
use Illuminate\Support\Facades\Route;
use Modules\Service\app\Http\Controllers\ServiceController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['middleware' => 'setlocale'], function() {

Route::prefix('provider')->group(function () {
    Route::get('/service/create', [ServiceController::class, 'providerAddServiceIndex'])->name('provider.add.service')->middleware('provider', 'permission');
    Route::post('/service/save', [ServiceController::class, 'providerServiceStore'])->name('provider.service.store');
    Route::post('/service/update', [ServiceController::class, 'providerServiceUpdate'])->name('provider.service.update');
    Route::post('/subscription/detail', [ServiceController::class, 'providerSub']);

    Route::get('/product/create', [ServiceController::class, 'productIndex'])->name('provider.product.create')->middleware('provider', 'permission');
    Route::post('/product/store', [ServiceController::class, 'productStore'])->name('provider.product.store')->middleware('provider', 'permission');
    Route::get('/product/edit/{id}', [ServiceController::class, 'edit'])->name('provider.product.edit')->middleware('provider', 'permission');
    Route::put('/product/update/{id}', [ServiceController::class, 'productUpdate'])->name('provider.product.update')->middleware('auth', 'permission');
});
Route::get('/provider/service', [ServiceController::class, 'providerService'])->name('provider.service')->middleware('provider', 'permission');
Route::get('/provider/product', [ServiceController::class, 'providerProduct'])->name('provider.product')->middleware('provider', 'permission');
Route::get('/provider/edit/{id}', [ServiceController::class, 'providerEditService'])->name('provider.edit.service')->middleware('provider', 'permission');
Route::post('/image-delete', [ServiceController::class, 'deleteImage'])->name('image.delete');

Route::post('/check-coupon', [ServiceController::class, 'checkCoupon'])->name('check-coupon');
Route::post('/product/check-coupon', [BookController::class, 'checkProductCoupon'])->name('product.check-coupon');
Route::post('admin/verify-service', [ServiceController::class, 'verifyService'])->name('admin.verify.service');

Route::prefix('product')->group(function () {
    Route::get('/list', [ServiceController::class, 'productListApi']);
    Route::get('/product-details/{slug}', [ServiceController::class, 'productDetails']);
    Route::post('/product-gallery', [ServiceController::class, 'galleryandvariatonApi']);
});

Route::prefix('services')->group(function () {
    Route::get('/list', [ServiceController::class, 'index']);
    Route::get('/service-details/{slug}', [ServiceController::class, 'serviceDetails']);
    Route::post('/save', [ServiceController::class, 'store'])->name('addservice');
    Route::post('/update', [ServiceController::class, 'update'])->name('updateservice');
});

});
