<?php

namespace Modules\Service\app\Models;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\ChangesHistory;
use Modules\Product\app\Models\Rating;
use Modules\Categories\app\Models\Categories;
use App\Models\Book;
use App\Models\Bookings;
use App\Models\ProductVariation;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Modules\Shops\app\Models\Shops;

/**
 * Class Service
 *
 * @property int $id
 * @property int $user_id
 * @property string $source_name
 * @property string $slug
 * @property string $source_code
 * @property string $source_type
 * @property string $source_tag
 * @property string $source_description
 * @property string $source_category
 * @property string $source_subcategory
 * @property float $source_price
 * @property string $plan
 * @property string $price_description
 * @property string $source_brand
 * @property int $source_stock
 * @property string $seo_title
 * @property string $tags
 * @property bool $featured
 * @property bool $popular
 * @property string $seo_description
 * @property string $price_type
 * @property string $duration
 * @property string $country
 * @property string $state
 * @property string $city
 * @property string $address
 * @property string $pincode
 * @property string $include
 * @property string $status
 * @property int $created_by
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property \Illuminate\Support\Carbon|null $deleted_at
 */

class Service extends Model
{
    use SoftDeletes;

    protected $table = 'products';

    protected $fillable = [
        'id',
        'user_id',
        'shop_id',
        'source_name',
        'slug',
        'source_code',
        'source_type',
        'source_tag',
        'source_description',
        'source_category',
        'source_subcategory',
        'source_price',
        'plan',
        'price_description',
        'source_brand',
        'source_stock',
        'seo_title',
        'tags',
        'featured',
        'popular',
        'seo_description',
        'price_type',
        'duration',
        'country',
        'state',
        'city',
        'address',
        'pincode',
        'include',
        'language_id',
        'parent_id',
        'status',
        'created_by',
        'verified_status',
        'shot_description',
        'domestic_shipping',
        'international_shipping',
    ];

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function ratings()
    {
        return $this->hasMany(Rating::class, 'product_id');
    }
    public function bookings()
    {
        return $this->hasMany(Bookings::class, 'product_id');
    }

    public function showproductname()
    {

        return $this->source_name;
    }
    public function category()
    {
        return $this->belongsTo(Categories::class, 'source_category');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function meta()
    {
        return $this->hasMany(\Modules\Product\app\Models\Productmeta::class, 'product_id');
    }

    public function variations()
    {
        return $this->hasMany(ProductVariation::class, 'product_id',);
    }

    public function image()
    {
        // A Product has one image record in the meta table
        return $this->hasOne(ProductMeta::class, 'product_id')
            ->where('source_key', 'product_image');
    }

    public function productImages()
    {
        return $this->hasMany(Productmeta::class, 'product_id', 'id')
            ->where('source_key', 'product_image');
    }

    public function specificationMeta()
    {
        return $this->hasOne(Productmeta::class, 'product_id', 'id')
            ->where('source_key', 'specification');
    }

    public function getSpecificationsAttribute()
    {
        if ($this->relationLoaded('specificationMeta') && $this->specificationMeta && !empty($this->specificationMeta->source_Values)) {
            return json_decode($this->specificationMeta->source_Values, true);
        }

        return [];
    }

    public function shop()
    {
        return $this->belongsTo(Shops::class, 'shop_id');
    }
}
