<?php

namespace Modules\Page\app\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\View\View;
use Modules\Page\app\Repositories\Contracts\PageRepositoryInterface;

class PageController extends Controller
{
    protected $pageRepository;

    public function __construct(PageRepositoryInterface $pageRepository) {
        $this->pageRepository = $pageRepository;
    }

    public function pageBuilderApi(Request $request): View|JsonResponse
    {
        $response = $this->pageRepository->pageBuilderApi($request);
        return $response;
    }

    public function deletePage(Request $request): JsonResponse
    {
        $response = $this->pageRepository->deletePage($request);
        return $response;
    }
}
