@extends('admin.admin')

@section('meta_title', __('Blogs') . ' || ' . $companyName)

@section('content')
<!-- Page Wrapper -->
<div class="page-wrapper">
    <div class="content me-0 me-md-0 me-lg-4">
         <div class="d-md-flex d-block align-items-center justify-content-between -bottom pb-3">
            <div class="my-auto mb-2">
                <h3 class="page-title mb-1">{{ __('Blog') }}</h3>
                <nav>
                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">{{ __('Blog') }}</li>
                    </ol>
                </nav>
            </div>
            <div class="d-flex my-xl-auto right-content align-items-center flex-wrap">
                <div class="mb-3 me-2">
                    @php
                        $langCode = \App::getLocale();
                        $language = \Modules\GlobalSetting\app\Models\Language::where('code', $langCode)->first();
                    @endphp
                    <select class="form-select d-none real-input" name="language" id="language">
                        <option value="">{{ __('Select') }}</option>
                        @if ($allLanguages->isNotEmpty())
                            @foreach ($allLanguages as $allLanguage)
                                <option value="{{ $allLanguage->id }}" {{ $allLanguage->id == $language->id ? 'selected' : '' }}>{{ $allLanguage->name }}</option>
                            @endforeach
                        @endif
                    </select>
                </div>
                <div class="mb-3">
                        <a href="/admin/content/add-blog" class="btn btn-primary"><i class="ti ti-square-rounded-plus-filled me-2"></i>{{ __('Add Blog') }}</a>
                </div>
            </div>
        </div>

        <!-- Table Header -->
        <div class="d-flex align-items-center justify-content-between flex-wrap row-gap-3 mb-3">
            <div class="d-flex align-items-center flex-wrap row-gap-3">
                <div class="dropdown me-2">
                    <button type="button" class="dropdown-toggle btn btn-white d-inline-flex align-items-center"
                        data-bs-toggle="dropdown" id="selectedFilterTextCategory">
                        <i class="ti ti-filter me-1"></i> {{ __('Sort by') }} :
                        <span>{{ __('Latest') }}</span>
                    </button>
                    <ul id="sortDropdownBlog" class="dropdown-menu dropdown-menu-end p-2">
                        <li><a href="javascript:void(0);" class="dropdown-item dropdown-item-blog rounded-1"
                                data-filter="latest">{{ __('Latest') }}</a></li>
                        <li><a href="javascript:void(0);" class="dropdown-item dropdown-item-blog rounded-1"
                                data-filter="asc">{{ __('Ascending') }}</a></li>
                        <li><a href="javascript:void(0);" class="dropdown-item dropdown-item-blog rounded-1"
                                data-filter="desc">{{ __('Descending') }}</a></li>
                        <li><a href="javascript:void(0);" class="dropdown-item dropdown-item-blog rounded-1"
                                data-filter="last_month">{{ __('Last month') }}</a></li>
                        <li><a href="javascript:void(0);" class="dropdown-item dropdown-item-blog rounded-1"
                                data-filter="last_7_days">{{ __('Last 7 days') }}</a></li>
                    </ul>
                </div>
                <div class="dropdown">
                    <button type="button"
                        class="filtercollapse coloumn d-inline-flex align-items-center"
                        data-bs-toggle="collapse"
                        data-bs-target="#filtercollapse"
                        aria-expanded="false"
                        aria-controls="filtercollapse">
                        <i class="ti ti-filter me-1"></i> {{ __('Filter') }}
                    </button>
                </div>
            </div>
            <div class="d-flex my-xl-auto right-content align-items-center flex-wrap row-gap-3">
                <div class="top-search me-2">
                    <div class="top-search-group">
                        <span class="input-icon">
                            <i class="ti ti-search"></i>
                        </span>
                        <input type="text" class="form-control" id="searchInputBlog"
                            placeholder="{{ __('Search') }}">
                    </div>
                </div>
            </div>
        </div>
        <!-- /Table Header -->
        <div class="collapse" id="filtercollapse">
            <div class="filterbox mb-3 d-flex align-items-center">
                <h6 class="me-3">{{ __('Filter') }}</h6>
                <div class="dropdown me-3">
                    <a href="javascript:void(0);" class="dropdown-toggle btn btn-white d-inline-flex align-items-center"
                        data-bs-toggle="dropdown" data-bs-auto-close="outside">
                        {{ __('Category') }}
                    </a>
                    <ul class="dropdown-menu dropdown-menu-lg p-2">
                        @foreach ($categories as $category)
                        <li>
                            <label class="dropdown-item d-flex align-items-center rounded-1">
                                <input class="form-check-input m-0 me-2 category-checkbox" type="checkbox"
                                    value="{{ $category->id }}">
                                {{ $category->name }}
                            </label>
                        </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
        <!-- Blogs -->
        <div class="row blogs-cover grid-view" id="blogList">
            @foreach ($blogPosts as $blogPost)
            <div class="col-lg-4 col-md-6 blog-item" data-date="{{ $blogPost->created_at }}"
                data-title="{{ $blogPost->title }}" data-category="{{ $blogPost->category }}">
                <div class="card blog-item-1">
                    <div class="card-body p-0">
                        <div class="blog-img">
                            <a href="/admin/content/blog-details/{{ $blogPost->slug }}">
                                @php
                                $imagePath = 'storage/' . $blogPost->image;
                                $defaultImage = asset('backend/assets/img/default-image-02.jpg');
                                @endphp
                                <img src="{{ file_exists(public_path($imagePath)) ? asset($imagePath) : $defaultImage }}"
                                    alt="Post">
                            </a>
                            <div class="edit-delete-btns d-flex align-items-center justify-content-between">
                                <div class="d-flex align-items-center">
                                    <a href="javascript:;" data-id="{{ $blogPost->id }}" id="blog-edit"
                                        class="blog-edit me-2"><i class="ti ti-edit"></i></a>
                                    <a href="javascript:void(0);" class="blog-delete" data-bs-toggle="modal"
                                        data-id="{{ $blogPost->id }}" data-bs-target="#delete_blogs"><i
                                            class="ti ti-trash"></i></a>
                                </div>
                                <span class="badge badge-info badge-md">
                                    <?php
                                    $category = isset($blogPost) ? Modules\GlobalSetting\app\Models\BlogCategory::where('id', $blogPost->category)->first() : null;
                                    ?>
                                    {{ ucfirst($category->name) ?? '-' }}
                                </span>
                            </div>
                        </div>
                        <div class="blog-content">
                            <div class="d-flex align-items-center justify-content-between mb-3">
                                <div class="d-flex align-items-center">
                                    <a href="javascript:void(0);">
                                        @php
                                        $imagePath = 'storage/' . $blogPost->profile_image;
                                        $defaultImage = asset('backend/assets/img/default-profile.png');
                                        @endphp
                                        <img src="{{ file_exists(public_path($imagePath)) ? asset($imagePath) : $defaultImage }}"
                                            class="avatar avatar-sm rounded-circle me-1" alt="Avatar">
                                    </a>
                                    <a href="javascript:void(0);" class="fs-16">{{ $blogPost->full_name }}</a>
                                </div>
                                <span class="d-flex align-items-center fs-16">
                                    <i class="ti ti-calendar me-1"></i>
                                    {{ formatDateTime($blogPost->created_at, false) }}
                                </span>
                            </div>
                            <h5><a
                                    href="/admin/content/blog-details/{{ $blogPost->slug }}">{{ $blogPost->title }}</a>
                            </h5>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
        <div class="d-flex align-items-center justify-content-center mt-3">
            @if (count($blogPosts) > 15)
            <a href="javascript:void(0);" class="load-btn btn btn-primary mt-3">
                <i class="ti ti-loader me-1"></i> {{ __('Load More') }}
            </a>
            @elseif(count($blogPosts) == 0)
            <p>{{ __('No Blog Found') }}</p>
            @endif
        </div>
        <!-- Blogs -->
    </div>
    @include('admin.partials.footer')
</div>
<!-- /Page Wrapper -->

<!-- Delete Blogs -->
<div class="modal fade" id="delete_blogs">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form id="deleteBlogPostForm">
                <div class="modal-body text-center">
                    <span class="delete-icon">
                        <i class="ti ti-trash-x"></i>
                    </span>
                    <h4>{{__('Confirm Deletion')}}</h4>
                    <p>{{__('Are you sure you want to delete this item? This action cannot be undone.')}}</p>
                    <input type="hidden" name="delete_id" id="delete_id">
                    <div class="d-flex justify-content-center">
                        <a href="javascript:void(0);" class="btn btn-light me-3" data-bs-dismiss="modal">{{__('Cancel')}}</a>
                        <button type="submit" class="btn btn-danger delete_post_confirm">{{__('Yes, Delete')}}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- /Delete Blogs -->
@endsection

@push('scripts')
<script src="{{ asset('backend/assets/js/global_setting/blog.js') }}"></script>
@endpush