<?php

namespace Modules\Faq\app\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class FaqUpdateRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'edit_id' => ['required', 'integer', 'exists:faqs,id'],
            'language_id' => ['required', 'integer', 'exists:languages,id'],
            'edit_question' => ['required', 'string', 'min:5', 'max:255'],
            'edit_answer' => ['required', 'string', 'min:10'],
            'status' => ['required', 'boolean'],
        ];
    }
}
