@extends('frontend.provider.app')

@section('content')

<div class="page-wrapper">
    <!-- Start Breadscrumb -->
    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ route('home') }}">{{ __('home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items"><a href="{{ route('provider.coupon') }}">{{ __('Coupons') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{__('add_coupon')}}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{__('add_coupon')}}</h1>
            </div>
        </div>
        <img src="/frontend/assets/img/elements/element-01.svg" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-02.svg" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-03.svg" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-04.svg" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-05.svg" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>
    <!-- End Breadscrumb -->

    <div class="content">
        <div class="container">
            <div class="row">
                @include('provider.partials.sidebar')

                <div class="col-xl-9 col-lg-8">
                    <div class="d-flex justify-content-between align-items-center flex-wrap">
                        <h5>{{ __('add_coupon') }}</h5>
                    </div>
                    <hr>

                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <form id="couponForm">
                                        <input type="hidden" id="create_by" name="created_by" value="{{ Auth::id() }}">
                                        <div class="general-info">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label">{{ __('Code') }}<span class="text-danger"> *</span></label>
                                                        <input type="text" class="form-control" id="code" name="code" placeholder="{{ __('enter_code') }}">
                                                        <span class="text-danger error-text" id="code_error" data-required="{{ __('code_required') }}" data-exists="{{ __('code_exists') }}" data-max="{{ __('code_max') }}"></span>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label">{{ __('Product Type') }}<span class="text-danger"> *</span></label>
                                                        <select class="form-control select2" id="product_type" name="product_type" data-placeholder="{{ __('select_product_type') }}">
                                                            <option value="">{{ __('select_product_type') }}</option>
                                                            <option value="all">{{ __('All') }}</option>
                                                            <option value="category">{{ __('Category') }}</option>
                                                            <option value="subcategory">{{ __('sub_category') }}</option>
                                                            <option value="service">{{ __('Service') }}</option>
                                                        </select>
                                                        <span class="text-danger error-text" id="product_type_error" data-required="{{ __('product_type_required') }}"></span>
                                                    </div>
                                                </div>
                                                <div class="col-md-6 d-none" id="category_field">
                                                    <div class="mb-3">
                                                        <label class="form-label">{{ __('Category') }}<span class="text-danger"> *</span></label>
                                                        <select class="form-control select2" id="category_id" name="category_id[]" data-placeholder="{{ __('select_category') }}" multiple>
                                                            @if ($categories)
                                                            @foreach ($categories as $category)
                                                            <option value="{{ $category->id }}">{{ $category->name }}</option>
                                                            @endforeach
                                                            @endif
                                                        </select>
                                                        <span class="text-danger error-text" id="category_id_error" data-required="{{ __('category_required') }}"></span>
                                                    </div>
                                                </div>
                                                <div class="col-md-6 d-none" id="subcategory_field">
                                                    <div class="mb-3">
                                                        <label class="form-label">{{ __('Sub Category') }}<span class="text-danger"> *</span></label>
                                                        <select class="form-control select2" id="subcategory_id" name="subcategory_id[]" data-placeholder="{{ __('select_sub_category') }}" multiple>
                                                            @if ($subcategories)
                                                            @foreach ($subcategories as $subcategory)
                                                            <option value="{{ $subcategory->id }}">{{ $subcategory->name }}</option>
                                                            @endforeach
                                                            @endif
                                                        </select>
                                                        <span class="text-danger error-text" id="subcategory_id_error" data-required="{{ __('sub_category_required') }}"></span>
                                                    </div>
                                                </div>
                                                <div class="col-md-6 d-none" id="product_field">
                                                    <div class="mb-3">
                                                        <label class="form-label">{{ __('Product') }}<span class="text-danger"> *</span></label>
                                                        <select class="form-control select2" id="product_id" name="product_id[]" data-placeholder="{{ __('select_product') }}" multiple>
                                                            @if ($products)
                                                            @foreach ($products as $product)
                                                            <option value="{{ $product->id }}">{{ $product->source_name }}</option>
                                                            @endforeach
                                                            @endif
                                                        </select>
                                                        <span class="text-danger error-text" id="product_id_error" data-required="{{ __('product_required') }}"></span>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label">{{ __('Coupon Type') }}<span class="text-danger"> *</span></label>
                                                        <select class="form-control select2" id="coupon_type" name="coupon_type" data-placeholder="{{ __('select_coupon_type') }}">
                                                            <option value="">{{ __('select_coupon_type') }}</option>
                                                            <option value="percentage">{{ __('percentage') }}</option>
                                                            <option value="fixed">{{ __('fixed') }}</option>
                                                        </select>
                                                        <span class="text-danger error-text" id="coupon_type_error" data-required="{{ __('coupon_type_required') }}"></span>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label">{{ __('Coupon Value') }}<span class="text-danger"> *</span></label>
                                                        <div class="input-group">
                                                            <input type="text" class="form-control" id="coupon_value" name="coupon_value" placeholder="{{ __('enter_coupon_value') }}">
                                                            <span class="input-group-text coupon_type_symbol">%</span>
                                                        </div>
                                                        <span class="text-danger error-text" id="coupon_value_error" data-required="{{ __('coupon_value_required') }}"></span>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label">{{ __('Quantity') }}<span class="text-danger"> *</span></label>
                                                        <select class="form-control select2" id="quantity" name="quantity" data-placeholder="{{ __('select_quantity') }}">
                                                            <option value="">{{ __('select_quantity') }}</option>
                                                            <option value="limited">{{ __('Limited') }}</option>
                                                            <option value="unlimited">{{ __('Unlimited') }}</option>
                                                        </select>
                                                        <span class="text-danger error-text" id="quantity_error" data-required="{{ __('quantity_required') }}"></span>
                                                    </div>
                                                </div>
                                                <div class="col-md-6 d-none" id="quantity_value_field">
                                                    <div class="mb-3">
                                                        <label class="form-label">{{ __('Quantity Value') }}<span class="text-danger"> *</span></label>
                                                        <input type="text" class="form-control" id="quantity_value" name="quantity_value" placeholder="{{ __('enter_quantity_value') }}">
                                                        <span class="text-danger error-text" id="quantity_value_error" data-required="{{ __('quantity_value_required') }}"></span>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label">{{ __('Start Date') }}<span class="text-danger"> *</span></label>
                                                        <input type="date" class="form-control" id="start_date" name="start_date" placeholder="dd-mm-yyyy">
                                                        <span class="text-danger error-text" id="start_date_error" data-required="{{ __('start_date_required') }}"></span>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label">{{ __('End Date') }}<span class="text-danger"> *</span></label>
                                                        <input type="date" class="form-control" id="end_date" name="end_date" placeholder="dd-mm-yyyy">
                                                        <span class="text-danger error-text" id="end_date_error" data-required="{{ __('end_date_required') }}"></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="acc-submit d-flex justify-content-end">
                                            <button type="submit" class="btn btn-secondary" id="save_coupon_btn" data-save="{{ __('Save') }}">{{ __('Save') }}</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@include('coupon::provider.includes')