@extends('frontend.provider.app')
@section('content')

<div class="page-wrapper">
    <!-- Start Breadscrumb -->
    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ route('home') }}">{{ __('home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{__('Coupon & Offers')}}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{__('Coupon & Offers')}}</h1>
            </div>
        </div>
        <img src="/frontend/assets/img/elements/element-01.svg" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-02.svg" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-03.svg" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-04.svg" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="/frontend/assets/img/elements/element-05.svg" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>
    <!-- End Breadscrumb -->

    <div class="content">
        <div class="container">
            <div class="row">
                @include('provider.partials.sidebar')

                <div class="col-xl-9 col-lg-8">
                    <div class="content">
                        <div class="d-flex align-items-center justify-content-between flex-wrap row-gap-3 mb-4">
                            <div class="my-auto mb-2">
                                <h3 class="page-title mb-1">{{ __('Coupon & Offers') }}</h3>
                            </div>
                            <div class="d-flex my-xl-auto right-content align-items-center flex-wrap">
                                <div class="mb-2">
                                    @if(isset($permission))
                                    @if(hasPermission($permission, 'Coupon', 'create'))
                                    <div class="skeleton label-skeleton label-loader"></div>
                                    <a href="{{ route('provider.create-coupon') }}" class="btn btn-secondary d-none real-label"><i class="ti ti-square-rounded-plus-filled me-2"></i>{{ __('add_coupon') }}</a>
                                    @endif
                                    @endif
                                </div>
                            </div>
                        </div>
                        @php $isVisible = 0; @endphp
                        @if(isset($permission))
                        @if(hasPermission($permission, 'Coupon', 'delete'))
                        @php $delete = 1; $isVisible = 1; @endphp
                        @else
                        @php $delete = 0; @endphp
                        @endif
                        @if(hasPermission($permission, 'Coupon', 'edit'))
                        @php $edit = 1; $isVisible = 1; @endphp
                        @else
                        @php $edit = 0; @endphp
                        @endif
                        <div id="has_permission" data-delete="{{ $delete }}" data-edit="{{ $edit }}" data-visible="{{ $isVisible }}"></div>
                        @else
                        @php $isVisible = 1; @endphp
                        <div id="has_permission" data-delete="1" data-edit="1"></div>
                        @endif
                        <div class="card">
                            <h5 class="page-title mt-3 ps-3">{{ __('total_coupons') }}</h5>

                            <div class="card-body p-0 py-3">
                                <div class="border-0">
                                    <div class="table-responsive table-nowrap">
                                        <input type="hidden" name="user_id" id="user_id" value="{{ Auth::id() }}">
                                        <table class="table d-none border" id="couponTable" data-empty="{{ __('coupon_empty_info') }}">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>{{ __('Coupon Code') }}</th>
                                                    <th>{{ __('Coupon Type') }}</th>
                                                    <th>{{ __('Coupon Value') }}</th>
                                                    <th>{{ __('Start Date') }}</th>
                                                    <th>{{ __('End Date') }}</th>
                                                    @if ($edit == 1)
                                                    <th>{{ __('Status') }}</th>
                                                    @endif
                                                    @if ($isVisible == 1)
                                                    <th class="no-sort">{{ __('Action') }}</th>
                                                    @endif
                                                </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>

                                        <!-- loader Datatable Start-->
                                        <table id="loader-table" class="table table-striped table-bordered">
                                            <thead class="table-dark">
                                                <tr>
                                                    <th>
                                                        <div class="skeleton label-skeleton label-loader"></div>
                                                        <p class="d-none real-label"></p>
                                                    </th>
                                                    <th>
                                                        <div class="skeleton label-skeleton label-loader"></div>
                                                        <p class="d-none real-label"></p>
                                                    </th>
                                                    <th>
                                                        <div class="skeleton label-skeleton label-loader"></div>
                                                        <p class="d-none real-label"></p>
                                                    </th>
                                                    <th>
                                                        <div class="skeleton label-skeleton label-loader"></div>
                                                        <p class="d-none real-label"></p>
                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                    <td>
                                                        <div class="skeleton data-skeleton data-loader"></div>
                                                        <p class="d-none real-data"></p>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <!-- loader Datatable End -->

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="delete_coupon_modal">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form id="deleteCouponForm">
                <div class="modal-body text-center">
                    <span class="delete-icon">
                        <i class="ti ti-trash-x"></i>
                    </span>
                    <h4>{{ __('are_you_sure') }}</h4>
                    <p>{{ __('Confirm Delete Coupon') }}</p>
                    <input type="hidden" name="delete_id" id="delete_id">
                    <div class="d-flex justify-content-center">
                        <a href="javascript:void(0);" class="btn btn-dark me-3" data-bs-dismiss="modal">{{ __('Cancel') }}</a>
                        <button type="submit" class="btn btn-danger delete_coupon_confirm">{{ __('Delete') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@include('coupon::provider.includes')