@extends('frontend.theme_2.app')

@section('title', __('Notifications') . ' || ' . $companyName)

@section('content')
<div class="page-wrapper">
    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ route('home') }}">{{ __('Home')}}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{ __('Notification')}}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{ __('Notification')}}</h1>
            </div>
        </div>
    </div>

    <div class="content">
        <div class="container">
            <div class="row">
                @include('frontend.pages.customer.sidemenu')
                <div class="col-xl-9 col-lg-8">
                    <div class="notification-header d-flex align-items-center justify-content-between flex-wrap gap-3">
                        <h4 class="mb-0">{{ __('Notifications')}}</h4>
                        <ul class="d-flex align-center gap-2 flex-wrap">
                            <li class="mb-0">
                                <a href="javascript:void(0);" id="mark-all-read-btn" class="btn btn-sm btn-white d-inline-flex align-items-center "><i class="isax isax-tick-circle me-1"></i>Mark all as read</a>
                            </li>
                            <li class="mb-0">
                                <a href="javascript:void(0);" class="btn btn-sm btn-danger d-inline-flex align-items-center" data-bs-toggle="modal" data-bs-target="#clear_all_modal"><i class="isax isax-trash me-1"></i>Clear all</a>
                            </li>
                        </ul>
                    </div>
                    <hr>
                    <div id="notification-list">
                        @forelse($data['notifications'] as $notification)
                            @php
                                // Determine the description based on the authenticated user
                                $description = ($data['auth_user'] == $notification->from_user_id)
                                    ? $notification->from_description
                                    : $notification->to_description;

                                // Determine icon and color based on notification source
                                $iconClass = 'isax-info-circle';
                                $bgClass = 'bg-soft-secondary text-secondary';
                                if (Str::contains(strtolower($notification->source), 'cancel')) {
                                    $iconClass = 'isax-calendar-remove';
                                    $bgClass = 'bg-soft-danger text-danger';
                                } elseif (Str::contains(strtolower($notification->source), 'new booking')) {
                                    $iconClass = 'isax-calendar-circle';
                                    $bgClass = 'bg-soft-secondary text-secondary';
                                } elseif (Str::contains(strtolower($notification->source), 'withdraw')) {
                                    $iconClass = 'isax-dollar-circle';
                                    $bgClass = 'bg-soft-pink text-pink';
                                } elseif (Str::contains(strtolower($notification->source), 'complete')) {
                                    $iconClass = 'isax-calendar-tick';
                                    $bgClass = 'bg-soft-success text-success';
                                }

                                $isUnread = ($notification->to_user_id == $data['auth_user'] && $notification->to_read_type == 0) ||
                                            ($notification->from_user_id == $data['auth_user'] && $notification->from_read_type == 0);
                            @endphp

                            <div class="notification-itemone border border-color" id="notification-{{ $notification->notification_id }}">
                                <div class="d-flex align-items-center justify-content-between flex-wrap flex-xl-nowrap gap-3">
                                    <div class="d-flex align-items-center  flex-wrap flex-lg-nowrap gap-3">
                                        <span class="avatar avatar-lg {{ $bgClass }} rounded-circle flex-shrink-0 d-inline-flex align-items-center justify-content-center">
                                            <i class="isax {{ $iconClass }} fs-20"></i>
                                        </span>
                                        <div>
                                            <h6>{{ $notification->source }}</h6>
                                            <p class="mb-1 text-body">{!! $description !!}</p>
                                            <p class="mb-0">{{ \Carbon\Carbon::parse($notification->created_at)->diffForHumans() }}</p>
                                        </div>
                                    </div>
                                    <div class="notification-delete">
                                        <a href="javascript:void(0);" class="btn btn-sm btn-danger btn-error delete-notification-btn" data-id="{{ $notification->notification_id }}" data-bs-toggle="modal" data-bs-target="#delete_notification_modal">
                                            <i class="isax isax-trash me-1"></i>Delete
                                        </a>
                                    </div>
                                </div>
                            </div>
                        @empty
                            <div class="card booking-list">
                                <div class="card-body d-flex align-items-center justify-content-center border-none">
                                    <h5 class="text-center w-100">{{__('No notifications found.')}}</h5>
                                </div>
                            </div>
                        @endforelse
                    </div>

                     @if ($data['notifications']->hasPages())
                        <div class="d-sm-flex align-items-center justify-content-between mt-4">
                            <div class="text-muted mb-3 mb-sm-0">
                                {{ __('showing') }} {{ $data['notifications']->firstItem() }} {{ __('to') }} {{ $data['notifications']->lastItem() }} {{ __('of') }} {{ $data['notifications']->total() }} {{ __('results') }}
                            </div>
                            <div class="pagination-container">
                                {{ $data['notifications']->links('pagination::bootstrap-4') }}
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="delete_notification_modal">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body text-center">
                <span class="delete-icon"><i class="isax isax-trash fs-16"></i></span>
                <h6 class="mb-1">{{ __('delete_notification') }}</h6>
                <p class="mb-3">{{ __('delete_notification_confirmation') }}</p>
                <div class="d-flex align-items-center justify-content-center">
                    <button type="button" class="btn btn-light w-100 me-2" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                    <button type="button" id="confirm-delete-btn" class="btn btn-danger w-100">{{ __('Delete') }}</button>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="clear_all_modal">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body text-center">
                <span class="delete-icon"><i class="isax isax-trash fs-16"></i></span>
                <h6 class="mb-1">{{ __('clear_all_notifications') }}</h6>
                <p class="mb-3">{{ __('clear_all_notifications_confirmation') }}</p>
                <div class="d-flex align-items-center justify-content-center">
                    <button type="button" class="btn btn-light w-100 me-2" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="button" id="confirm-clear-all-btn" class="btn btn-danger w-100">{{ __('clear_all') }}</button>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="{{ asset('frontend/assets/js/custom/notification.js') }}"></script>
@endpush