<?php

$projectId = env('FIREBASE_PROJECT_ID');

return [
    'fcm' => [
        'project_id' => $projectId,
        'client_email' => env('FIREBASE_CLIENT_EMAIL'),
        'private_key' => env('FIREBASE_PRIVATE_KEY'),
        'service_account' => env(
            'FIREBASE_SERVICE_ACCOUNT_PATH',
            storage_path('firebase/firebase_service_account.json'),
        ),
        'url' => env('FIREBASE_FCM_URL')
            ?: ($projectId ? sprintf('https://fcm.googleapis.com/v1/projects/%s/messages:send', $projectId) : null),
    ],
];
