<?php

namespace Modules\Chat\app\Transformers;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class ChatResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        $authUser = Auth::user();
        $position = $authUser && (int) $this->from_user_id === (int) $authUser->id ? 'right' : 'left';

        return [
            'id' => $this->id,
            'message_id' => $this->id,
            'message_type' => $this->type,
            'file_path' => $this->resolveFilePath($this->file),
            'from_user_id' => $this->from_user_id,
            'to_user_id' => $this->to_user_id,
            'content' => $this->content,
            'position' => $position,
            'created_at' => optional($this->created_at)?->toDateTimeString(),
            'created_at_humantime' => optional($this->created_at)?->diffForHumans(),
        ];
    }

    private function resolveFilePath(?string $file): ?string
    {
        if (empty($file)) {
            return null;
        }

        if (Str::startsWith($file, ['http://', 'https://'])) {
            return $file;
        }

        if (Storage::disk('public')->exists($file)) {
            return Storage::url($file);
        }

        return asset('assets/img/profile-default.png');
    }
}
