<?php
namespace Modules\Chat\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Message extends Model
{
    use SoftDeletes;

    protected $table = 'message';

    protected $fillable = [
        'content',
        'from_user_id',
        'to_user_id',
        'type',
        'file',
        'mime_type',
        'size',
        'created_by',
        'updated_by',
    ];

    protected $casts = [
        'from_user_id' => 'integer',
        'to_user_id' => 'integer',
        'size' => 'integer',
    ];
}
