@extends('frontend.theme_2.app')

@section('title', __('service_categories') . ' || ' . $companyName)

@section('content')

<div class="page-wrapper">
    <!-- Start Breadscrumb -->
    <div class="breadcrumb-bar">
        <div class="container">
            <div class="breadcrumb-item">
                <nav aria-label="breadcrumb" class="page-breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-items"><a href="{{ route('home') }}">{{ __('home') }}</a></li>
                        <li class="breadcrumb-items"><span><i class="isax isax-arrow-right-3"></i></span></li>
                        <li class="breadcrumb-items active" aria-current="page">{{ __('service_categories') }}</li>
                    </ol>
                </nav>
                <h1 class="breadcrumb-title">{{ __('service_categories') }}</h1>
            </div>
        </div>
        <img src="{{ asset('frontend/assets/img/elements/element-01.svg') }}" alt="elements" class="img-fluid element-one position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-02.svg') }}" alt="elements" class="img-fluid element-two position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-03.svg') }}" alt="elements" class="img-fluid element-three position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-04.svg') }}" alt="elements" class="img-fluid element-four position-absolute d-none d-lg-block">
        <img src="{{ asset('frontend/assets/img/elements/element-05.svg') }}" alt="elements" class="img-fluid element-five position-absolute d-none d-lg-block">
    </div>
    <!-- End Breadscrumb -->

    <!-- Start Content -->
    <div class="content">
        <div class="container">

            <!-- Start Sub Head -->
            <div class="sub-head-item border-bottom border-color d-flex align-items-center justify-content-between flex-wrap gap-2 pb-4 mb-4">
                <p class="sub-head mb-0"></p>
                <div class="filter-item d-flex align-items-center justify-content-between flex-wrap gap-3">
                    <div class="dropdown d-flex align-items-center gap-2">
                        <p class="fs-14 fw-medium mb-0">{{ __('sort_by') }} : </p>
                        <a href="javascript:void(0);" class="dropdown-toggle btn border border-color d-inline-flex align-items-center fw-normal" data-bs-toggle="dropdown" aria-expanded="false">
                            <span class="selected-value">{{ __('newest') }}</span> <i class="isax isax-arrow-down-3"></i>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li>
                                <a href="javascript:void(0);" class="dropdown-item rounded-1 sort-by" data-value="newest">{{ __('newest') }}</a>
                            </li>
                            <li>
                                <a href="javascript:void(0);" class="dropdown-item rounded-1 sort-by" data-value="oldest">{{ __('oldest') }}</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <!-- end Sub Head -->

            <div class="row row-gap-4 justify-content-center">
                @include('frontend.loader.content_loader')
            </div>
            <!-- start row -->
            <div class="row row-gap-4 justify-content-center" id="category_list_container">
            </div>
            <div class="text-center mt-5">
                <button type="button" class="btn btn-dark d-inline-flex align-items-center gap-2 load-more-btn d-none">
                    <i class="isax isax-rotate-left"></i>{{ __('load_more') }}
                </button>
            </div>

        </div>
    </div>
    <!-- End Content -->
</div>

@endsection

@push('scripts')
    <script src="{{ asset('frontend/assets/js/custom/service-categories.js') }}"></script>
@endpush